<!-- PESANAN -->
<div class="card shadow-sm mt-4">
    <div class="card-header bg-dark text-white fw-bold d-flex justify-content-between align-items-center">
        <span><i class="bi bi-receipt"></i> Daftar Pesanan</span>
        <span class="badge bg-secondary">Total: <?= count($menu); ?></span>
    </div>

    <div class="card-body p-0">
        <div class="table-responsive">
            <table class="table table-hover align-middle mb-0">
                <thead class="table-light">
                    <tr>
                        <th class="text-center">No</th>
                        <th>Kode Pesanan</th>
                        <th>Nama Pelanggan</th>
                        <th>Kode Menu</th>
                        <th class="text-center">Jumlah</th>
                    </tr>
                </thead>

                <tbody>
                <?php if (empty($menu)) { ?>
                    <tr>
                        <td colspan="5" class="text-center text-muted py-4">
                            Belum ada pesanan
                        </td>
                    </tr>
                <?php } else { ?>
                    <?php $i = 1; foreach ($menu as $m) { ?>
                    <tr>
                        <td class="text-center"><?= $i; ?></td>
                        <td>
                            <span class="fw-bold"><?= $m["kode_pesanan"]; ?></span>
                        </td>
                        <td><?= $m["nama_pelanggan"]; ?></td>
                        <td>
                            <span class="badge bg-info text-dark">
                                <?= $m["kode_menu"]; ?>
                            </span>
                        </td>
                        <td class="text-center">
                            <span class="badge bg-success">
                                <?= $m["qty"]; ?>
                            </span>
                        </td>
                    </tr>
                    <?php $i++; } ?>
                <?php } ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
