<?php
session_start();
require_once "function.php";

if (isset($_POST["login"])) {
    $login = login_akun();
} else if (isset($_POST["register"])) {
    $register = register_akun();
    echo $register > 0
        ? "<script>alert('Berhasil Registrasi!'); location.href='login.php';</script>"
        : "<script>alert('Gagal Registrasi!'); location.href='login.php';</script>";
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>Login | CoffeeShop</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <link rel="stylesheet" href="./src/css/bootstrap-5.2.0/css/bootstrap.min.css">
    <link rel="stylesheet" href="./src/css/bootstrap-icons-1.8.3/bootstrap-icons.css">

    <style>
        body {
            min-height: 100vh;
            background: linear-gradient(135deg, #212529, #343a40);
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .login-card {
            width: 420px;
            background: #fff;
            border-radius: 14px;
            box-shadow: 0 20px 45px rgba(0,0,0,0.25);
            padding: 35px;
            animation: fadeZoom 0.5s ease;
        }

        @keyframes fadeZoom {
            from {
                opacity: 0;
                transform: scale(0.9);
            }
            to {
                opacity: 1;
                transform: scale(1);
            }
        }

        .brand {
            text-align: center;
            margin-bottom: 25px;
        }

        .brand i {
            font-size: 40px;
            color: #198754;
        }

        .brand h4 {
            margin-top: 10px;
            font-weight: bold;
        }

        .tab-btn {
            width: 48%;
        }

        .form-control {
            padding: 10px 14px;
        }
    </style>
</head>

<body>

<div class="login-card">

    <!-- BRAND -->
    <div class="brand">
        <i class="bi bi-cup-hot-fill"></i>
        <h4>Warkop Abang Puteh</h4>
        <small class="text-muted">sistem kasir berbasis web modern dan efisien</small>
    </div>

    <!-- TAB LOGIN & REGISTER -->
    <div class="d-flex justify-content-between mb-4">
        <button id="tab-login" class="btn btn-success fw-bold tab-btn">
            LOGIN
        </button>
        <button id="tab-register" class="btn btn-outline-success fw-bold tab-btn">
            REGISTER
        </button>
    </div>

    <!-- ALERT LOGIN GAGAL -->
    <?php if (isset($_POST["login"]) && !$login): ?>
        <div class="alert alert-danger alert-dismissible fade show">
            Username atau password salah
            <button class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif; ?>

    <!-- FORM -->
    <form id="form" action="login.php" method="POST">

        <div class="mb-3">
            <label class="form-label">Username</label>
            <input type="text"
                   name="username"
                   class="form-control"
                   autocomplete="off"
                   required>
        </div>

        <div class="mb-4">
            <label class="form-label">Password</label>
            <input type="password"
                   name="password"
                   class="form-control"
                   required>
        </div>

        <button class="btn btn-success w-100 fw-bold" name="login">
            <i class="bi bi-box-arrow-in-right"></i> Login
        </button>
    </form>

</div>

<script src="./src/css/bootstrap-5.2.0/js/bootstrap.bundle.min.js"></script>
<script src="./src/js/login.js"></script>

</body>
</html>
