<?php
// ================= PENCARIAN =================
if (isset($_GET["search"]) && !empty($_GET["key-search"])) {
    $keyword = strtolower(trim($_GET["key-search"]));

    $menu = array_filter($menu, function ($m) use ($keyword) {
        return strpos(strtolower($m["nama"]), $keyword) !== false
            || strpos(strtolower($m["kategori"]), $keyword) !== false;
    });
}

// ================= KELOMPOK KATEGORI =================
$kategoriMenu = [];
foreach ($menu as $m) {
    $kategoriMenu[$m["kategori"]][] = $m;
}

$i = 1; // wajib
?>

<!-- ================= STICKY SEARCH & PEMESANAN ================= -->
<div class="card sticky-top glass-bar mb-4" style="top:65px; z-index:1020;">
    <div class="card-body py-2">
        <div class="row g-2 align-items-center">

            <!-- SEARCH -->
            <div class="col-lg-4 col-md-6">
                <form action="index.php" method="GET" class="input-group input-group-sm">
                    <span class="input-group-text bg-transparent border-0">
                        <i class="bi bi-search"></i>
                    </span>
                    <input type="search"
                           name="key-search"
                           class="form-control"
                           placeholder="Cari menu..."
                           autocomplete="off"
                           value="<?= $_GET['key-search'] ?? '' ?>">
                    <button class="btn btn-success btn-sm fw-semibold" name="search">
                        Cari
                    </button>
                </form>
            </div>

            <!-- NAMA PELANGGAN -->
            <div class="col-lg-4 col-md-6">
                <div class="input-group input-group-sm">
                    <span class="input-group-text bg-transparent border-0">
                        <i class="bi bi-person"></i>
                    </span>
                    <input type="text"
                           name="pelanggan"
                           form="form-pemesanan"
                           class="form-control"
                           placeholder="Nama pelanggan"
                           autocomplete="off"
                           required>
                </div>
            </div>

            <!-- AKSI -->
            <div class="col-lg-4">
                <div class="d-flex gap-2">

                    <button class="btn btn-success btn-sm fw-bold flex-fill"
                            name="pesan"
                            form="form-pemesanan">
                        <i class="bi bi-cart-check"></i> Pesan
                    </button>

                    <?php if (isset($_SESSION["akun-admin"])): ?>
                    <a href="tambah.php"
                       class="btn btn-primary btn-sm fw-bold flex-fill">
                        <i class="bi bi-plus-circle"></i> Tambah
                    </a>
                    <?php endif; ?>

                </div>
            </div>

        </div>
    </div>
</div>


<!-- ================= FORM PEMESANAN ================= -->
<form action="index.php" method="POST" id="form-pemesanan">


<?php foreach ($kategoriMenu as $kategori => $items): ?>

<!-- JUDUL KATEGORI -->
<div class="d-flex align-items-center mt-4 mb-3">
    <h5 class="fw-bold text-uppercase mb-0">
        <?= htmlspecialchars($kategori); ?>
    </h5>
    <hr class="flex-grow-1 ms-3">
</div>

<!-- GRID MENU -->
<div class="row g-3">

<?php foreach ($items as $m): ?>

<div class="col-xl-2 col-lg-3 col-md-4 col-sm-6">
    <div class="card h-100 border-0 shadow-sm">

        <!-- IMAGE -->
        <div class="position-relative">
            <img src="src/img/<?= $m["gambar"]; ?>"
                 class="card-img-top"
                 style="height:140px; object-fit:cover;"
                 alt="<?= htmlspecialchars($m["nama"]); ?>">

            <span class="badge position-absolute top-0 end-0 m-2
                <?= strtolower($m["status"]) === "tersedia" ? "bg-success" : "bg-danger"; ?>">
                <?= strtoupper($m["status"]); ?>
            </span>
        </div>

        <!-- BODY -->
        <div class="card-body p-2 d-flex flex-column">

            <h6 class="fw-bold text-truncate mb-1"
                title="<?= htmlspecialchars($m["nama"]); ?>">
                <?= $m["nama"]; ?>
            </h6>

            <div class="fw-bold text-primary mb-2">
                Rp <?= number_format($m["harga"], 0, ',', '.'); ?>
            </div>

            <input type="hidden"
                   name="kode_menu<?= $i; ?>"
                   value="<?= $m["kode_menu"]; ?>">

            <!-- QTY SPINNER -->
            <div class="mt-auto">
                <div class="input-group input-group-sm">
                    <span class="input-group-text">Jumlah</span>

                    <button type="button"
                            class="btn btn-outline-secondary"
                            onclick="spinnerQty('qty<?= $i ?>', -1)"
                            <?= strtolower($m["status"]) !== "tersedia" ? "disabled" : ""; ?>>
                        −
                    </button>

                    <input type="number"
                           id="qty<?= $i ?>"
                           class="form-control text-center"
                           name="qty<?= $i ?>"
                           value="0"
                           min="0"
                           readonly
                           <?= strtolower($m["status"]) !== "tersedia" ? "disabled" : ""; ?>>

                    <button type="button"
                            class="btn btn-outline-secondary"
                            onclick="spinnerQty('qty<?= $i ?>', 1)"
                            <?= strtolower($m["status"]) !== "tersedia" ? "disabled" : ""; ?>>
                        +
                    </button>
                </div>
            </div>

        </div>

        <!-- ADMIN -->
        <?php if (isset($_SESSION["akun-admin"])): ?>
        <div class="card-footer bg-transparent border-0 d-flex gap-2 px-2 pb-2">
            <a href="edit.php?id_menu=<?= $m["id_menu"]; ?>"
               class="btn btn-outline-warning btn-sm w-100">
                <i class="bi bi-pencil-square"></i>
            </a>
            <a href="hapus.php?id_menu=<?= $m["id_menu"]; ?>"
               class="btn btn-outline-danger btn-sm w-100"
               onclick="return confirm('Hapus menu ini?')">
                <i class="bi bi-trash"></i>
            </a>
        </div>
        <?php endif; ?>

    </div>
</div>

<?php $i++; endforeach; ?>

</div>

<?php endforeach; ?>

</form>

<!-- ================= SCRIPT QTY ================= -->
<script>
function spinnerQty(id, delta) {
    const input = document.getElementById(id);
    let value = parseInt(input.value) || 0;
    value += delta;
    if (value < 0) value = 0;
    input.value = value;
}
</script>
