<?php
session_start();

if (!isset($_SESSION["akun-admin"]) && !isset($_SESSION["akun-user"])) {
    header("Location: login.php");
    exit;
}

session_unset();
session_destroy();
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>Logout</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <link rel="stylesheet" href="./src/css/bootstrap-5.2.0/css/bootstrap.min.css">
    <link rel="stylesheet" href="./src/css/bootstrap-icons-1.8.3/bootstrap-icons.css">

    <style>
        body {
            height: 100vh;
            display: flex;
            justify-content: center;
            align-items: center;
            background: linear-gradient(135deg, #212529, #343a40);
        }

        .logout-box {
            background: white;
            padding: 40px;
            border-radius: 12px;
            text-align: center;
            box-shadow: 0 15px 40px rgba(0,0,0,0.25);
            animation: fadeZoom 0.5s ease;
        }

        @keyframes fadeZoom {
            from {
                opacity: 0;
                transform: scale(0.85);
            }
            to {
                opacity: 1;
                transform: scale(1);
            }
        }
    </style>
</head>

<body>

<div class="logout-box">
    <i class="bi bi-check-circle-fill text-success fs-1 mb-3"></i>
    <h4 class="fw-bold">Logout Berhasil</h4>
    <p class="text-muted mb-0">
        Anda telah keluar dari sistem
    </p>
    <small class="text-muted">
        Mengalihkan ke halaman login...
    </small>
</div>

<script>
    setTimeout(() => {
        window.location.href = "login.php";
    }, 2000);
</script>

</body>
</html>
